'''

 _   _                   ______       _ _ 
| \ | |                  | ___ \     | | |
|  \| | ___  ___  _ __   | |_/ / __ _| | |
| . ` |/ _ \/ _ \| '_ \  | ___ \/ _` | | |
| |\  |  __/ (_) | | | | | |_/ / (_| | | |
\_| \_/\___|\___/|_| |_| \____/ \__,_|_|_|

A blender game developed by sdfgeoff

__author__: "Geoffrey Irons"
__data__: "06-06-2013"
__version__: "0:0"
'''


import bge

FILE = open(bge.logic.expandPath('//settings.cfg')).readlines()

###############################################################################
#                            SOUND AND MUSIC                                  #
###############################################################################
def get_effects():
    return int(get_value('effects'))

def get_music():
    return int(get_value('music'))

def menu_sound(cont):
    if get_effects() == True:
        cont.activate(cont.actuators[0])


###############################################################################
#                                 LEVEL                                       #
###############################################################################

def get_start_level():
    '''Get's the current level that the player is up to'''
    return int(get_value('level'))

def increase_start_level():
    '''Increases the start level by 1'''
    set_start_level(get_start_level()+1)

def reset_start_level():
    '''Resets the start level to 1'''
    set_start_level(1)

def set_start_level(num):
    '''Sets the start level to whatever number you like'''
    set_value('level', num)

###############################################################################
#                                GRAPHICS                                     #
###############################################################################

def get_blur():
    '''Get's the user setting for the blur 2D filter'''
    return (bool(int(get_value('blur'))))

def get_bloom():
    '''Get's the user setting for the bloom 2D filter'''
    return (bool(int(get_value('bloom'))))


###############################################################################
#                            FILE MANAGEMENT                                  #
###############################################################################
def set_value(identifier, value):
    '''Writes to the configuration file with some identifiers new value'''
    outstr = ''
    for line in FILE:
        if line.startswith(identifier):
            outstr += '{} {}\n'.format(identifier, value)
        else:
            outstr += line
    open(bge.logic.expandPath('//settings.cfg'), 'w').write(outstr)

def get_value(identifier):
    '''Get's an identifier's existing value'''
    return [line for line in FILE if line.startswith(identifier)][0].split(' ')[1].strip()

def reload_options():
    global FILE
    FILE = open(bge.logic.expandPath('//settings.cfg')).readlines()

###############################################################################
#                               OPTIONS MENU                                  #
###############################################################################
def toggle_blur(cont):
    '''Toggles blur'''
    for sens in cont.sensors:
        if sens.positive != True:
            return
    set_value('blur', int(not get_blur()))
    reload_options()

def set_blur_visibility(cont):
    '''Set's current objects visibility based on if blur is on or not'''
    cont.owner.visible = get_blur()

def toggle_bloom(cont):
    '''Toggles bloom'''
    for sens in cont.sensors:
        if sens.positive != True:
            return
    set_value('bloom', int(not get_bloom()))
    reload_options()

def set_bloom_visibility(cont):
    '''Set's current objects visibility based on if blur is on or not'''
    cont.owner.visible = get_bloom()

def reset_start_level_option(cont):
    '''resets the start level from the menu'''
    for sens in cont.sensors:
        if sens.positive != True:
            return
    reset_start_level()






def toggle_music(cont):
    for sens in cont.sensors:
        if sens.positive != True:
            return
    set_value('music', int(not get_music()))
    reload_options()

def set_music_visibility(cont):
    cont.owner.visible = get_music()

def toggle_effects(cont):
    for sens in cont.sensors:
        if sens.positive != True:
            return
    set_value('effects', int(not get_effects()))
    reload_options()

def set_effects_visibility(cont):
    cont.owner.visible = get_effects()
